<?xml version="1.0" encoding="UTF-8"?>
<%--
 ===================================================================
  Licensed Materials - Property of IBM
 
  WebSphere Commerce
 
  (c) Copyright International Business Machines Corporation.
      2007, 2008
      All Rights Reserved.
 
  US Government Users Restricted Rights - Use, duplication or
  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 ===================================================================
 <wcf:contextData name="storeId" data="${param.storeId}"/>
	<wcf:param name="projectId" value="${param.recipeId}"/>	
--%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://commerce.ibm.com/foundation" prefix="wcf"%>
<% System.out.println("this is get recipe by recipeId ******"); 

%>
<wcf:getData type="com.mycompany.commerce.project.facade.datatypes.ProjectType[]"
	var="projects"
	expressionBuilder="getProjectsByprojectId"
	varShowVerb="showVerb">
	   <wcf:contextData name="storeId" data="${param.storeId}"/>	
		<wcf:param name="projectId" value="${param.recipeId}"/>	
</wcf:getData>
	
<c:forEach var="project" items="${projects}">
		<c:set var="recipeOwningStoreId" value="${project.projectIdentifier.externalIdentifier.storeIdentifier.uniqueID}" />
		<c:set var="objectType" value="Recipe" /> 	 
		<c:if test="${param.storeId != recipeOwningStoreId}">
			<c:set var="objectType" value="InheritedRecipe" /> 				          			
		</c:if> 
		<jsp:directive.include file="serialize/SerializeRecipe.jspf"/>
	</c:forEach>



